<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Subscription;
use Carbon\Carbon;

class ExpireSubscriptions extends Command
{
    protected $signature = 'subscriptions:expire';

    protected $description = 'Marca como vencidas las suscripciones expiradas';

    public function handle()
    {
        $expired = Subscription::where('status', 'activa')
            ->whereDate('end_date', '<', Carbon::now())
            ->update([
                'status' => 'vencida'
            ]);

        $this->info("Suscripciones vencidas: {$expired}");

        return Command::SUCCESS;
    }
}
