<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\ClassSession;
use App\Models\Attendance;
use Carbon\Carbon;

class Attendances extends Component
{
    public function render()
    {
        return view('livewire.admin.attendances', [
            'classes' => ClassSession::with(['coach','discipline','attendances.user'])
                ->whereDate('start_time', Carbon::today())
                ->orderBy('start_time')
                ->get(),
        ]);
    }

    public function markAttendance(Attendance $attendance)
    {
        if ($attendance->attended_at) {
            return;
        }

        $attendance->update([
            'attended_at' => now(),
        ]);
    }

    public function closeClass(ClassSession $class)
    {
        $class->update([
            'status' => 'completada',
        ]);
    }
}
