<?php

namespace App\Livewire\Admin\History;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\AdminLog;
use App\Models\User;

class Logs extends Component
{
    use WithPagination;

    protected $paginationTheme = 'tailwind';

    public $user_id;
    public $action;
    public $from;
    public $to;

    public function render()
    {
        $query = AdminLog::with('admin')
            ->orderBy('created_at', 'desc');

        if ($this->user_id) {
            $query->where('user_id', $this->user_id);
        }

        if ($this->action) {
            $query->where('action', 'like', "%{$this->action}%");
        }

        if ($this->from) {
            $query->whereDate('created_at', '>=', $this->from);
        }

        if ($this->to) {
            $query->whereDate('created_at', '<=', $this->to);
        }

        return view('livewire.admin.history.logs', [
            'logs' => $query->paginate(20),
            'admins' => User::role(['admin','superadmin'])->get(),
        ]);
    }

    public function resetFilters()
    {
        $this->reset([
            'user_id',
            'action',
            'from',
            'to',
        ]);
    }
}
