<?php

namespace App\Livewire\SuperAdmin\Openpay;

use Livewire\Component;
use App\Models\OpenpaySetting;

class Settings extends Component
{
    public $mode = 'sandbox';

    public $sandbox_merchant_id;
    public $sandbox_public_key;
    public $sandbox_private_key;
    public $sandbox_endpoint;

    public $production_merchant_id;
    public $production_public_key;
    public $production_private_key;
    public $production_endpoint;

    public function mount()
    {
        $settings = OpenpaySetting::first();

        if ($settings) {
            $this->fill($settings->toArray());
        }
    }

    protected function rules()
    {
        return [
            'mode' => 'required|in:sandbox,production',

            'sandbox_merchant_id' => 'required',
            'sandbox_public_key' => 'required',
            'sandbox_private_key' => 'required',
            'sandbox_endpoint' => 'required',

            'production_merchant_id' => 'nullable',
            'production_public_key' => 'nullable',
            'production_private_key' => 'nullable',
            'production_endpoint' => 'nullable',
        ];
    }

    public function save()
    {
        $this->validate();

        OpenpaySetting::updateOrCreate(
            ['id' => 1],
            $this->only([
                'mode',
                'sandbox_merchant_id',
                'sandbox_public_key',
                'sandbox_private_key',
                'sandbox_endpoint',
                'production_merchant_id',
                'production_public_key',
                'production_private_key',
                'production_endpoint',
            ])
        );

        session()->flash('success', 'Configuración OpenPay guardada correctamente.');
    }

    public function render()
    {
        return view('livewire.superadmin.openpay.settings');
    }
}
