<?php

namespace App\Livewire\SuperAdmin;

use Livewire\Component;
use App\Models\User;
use Spatie\Permission\Models\Permission;

class Permissions extends Component
{
    public $showModal = false;
    public $selectedUser;
    public $userPermissions = [];

    public function render()
    {
        return view('livewire.superadmin.permissions', [
            'users' => User::with(['roles', 'permissions'])->get(),
            'permissions' => Permission::all(),
        ]);
    }

    public function editPermissions(User $user)
    {
        $this->selectedUser = $user;
        $this->userPermissions = $user->permissions->pluck('name')->toArray();
        $this->showModal = true;
    }

    public function savePermissions()
    {
        $this->selectedUser->syncPermissions($this->userPermissions);
        $this->showModal = false;
    }
}
