<?php

namespace App\Livewire\User;

use Livewire\Component;
use App\Models\ClassSession;
use App\Models\Subscription;
use App\Models\Attendance;

class Agenda extends Component
{
    public function render()
    {
        $user = auth()->user();

        $subscription = Subscription::where('user_id', $user->id)
            ->where('status', 'activa')
            ->first();

        $classes = ClassSession::with(['coach','discipline'])
            ->where('start_time', '>', now())
            ->where('status', 'disponible')
            ->orderBy('start_time')
            ->get();

        return view('livewire.user.agenda', [
            'subscription' => $subscription,
            'classes' => $classes,
        ]);
    }

    public function enroll(int $classId)
    {
        $user = auth()->user();

        $subscription = Subscription::where('user_id', $user->id)
            ->where('status', 'activa')
            ->firstOrFail();

        Attendance::create([
            'user_id' => $user->id,
            'class_session_id' => $classId,
        ]);

        if ($subscription->remaining_classes !== null) {
            $subscription->decrement('remaining_classes');
        }
    }
}
