<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Discipline extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Relación con clases
     */
    public function classSessions()
    {
        return $this->hasMany(ClassSession::class);
    }

    /**
     * Helpers
     */
    public function isActive(): bool
    {
        return $this->is_active;
    }
}
