<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('class_sessions', function (Blueprint $table) {
  $table->id();
  $table->foreignId('coach_id')->constrained()->cascadeOnDelete();
  $table->foreignId('discipline_id')->constrained()->cascadeOnDelete();
  $table->dateTime('start_time');
  $table->dateTime('end_time');
  $table->integer('max_capacity');
  $table->enum('status', [
      'disponible',
      'llena',
      'cancelada',
      'completada'
  ])->default('disponible');
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_sessions');
    }
};
