<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('openpay_webhooks', function (Blueprint $table) {
  $table->id();
  $table->string('event_type')->nullable();
  $table->string('transaction_id')->nullable();
  $table->json('payload');
  $table->enum('status', ['received','processed','failed'])->default('received');
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('openpay_webhooks');
    }
};
