<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('openpay_settings', function (Blueprint $table) {
  $table->id();

  $table->enum('mode', ['sandbox', 'production'])->default('sandbox');

  // SANDBOX (obligatorio)
  $table->string('sandbox_merchant_id');
  $table->string('sandbox_public_key');
  $table->string('sandbox_private_key');
  $table->string('sandbox_endpoint');

  // PRODUCCIÓN (opcional)
  $table->string('production_merchant_id')->nullable();
  $table->string('production_public_key')->nullable();
  $table->string('production_private_key')->nullable();
  $table->string('production_endpoint')->nullable();

  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('openpay_settings');
    }
};
