<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->foreignId('promotion_id')
                ->nullable()
                ->after('package_id')
                ->constrained('promotions')
                ->nullOnDelete();

            $table->decimal('promotion_percent', 5, 2)
                ->nullable()
                ->after('promotion_id')
                ->comment('Porcentaje aplicado al momento del pago');
        });
    }

    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropForeign(['promotion_id']);
            $table->dropColumn(['promotion_id', 'promotion_percent']);
        });
    }
};
