<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Usuario</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
</head>
<body class="bg-gray-100 min-h-screen">

    {{-- NAVBAR --}}
    <nav class="bg-white shadow px-6 py-3 flex justify-between">
        <span class="font-bold">Pilates App</span>

        <div class="flex items-center gap-3">
            <span>{{ auth()->user()->name }}</span>

            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button class="text-sm text-red-500">Salir</button>
            </form>
        </div>
    </nav>

    {{-- CONTENIDO --}}
    <main class="p-6">
        {{ $slot }}
    </main>

    @livewireScripts
</body>
</html>
