<div>

    <h1 class="text-2xl font-bold mb-6">
        Agenda de Clases (Admin)
    </h1>

    {{-- SELECTOR DE CLIENTE --}}
    <div class="mb-6 max-w-md">
        <label class="block text-sm font-semibold mb-1">
            Cliente
        </label>

        <select
            wire:model="selectedUser"
            class="w-full border rounded-xl p-2"
        >
            <option value="">Selecciona un cliente</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">
                    {{ $user->name }}
                </option>
            @endforeach
        </select>

        @error('selectedUser')
            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
        @enderror
    </div>

    {{-- LISTA DE CLASES --}}
    <div class="grid md:grid-cols-2 gap-6">

        @foreach($classes as $class)
            <div class="bg-white rounded-xl shadow p-5">

                <h2 class="text-lg font-semibold">
                    {{ $class->discipline->name }}
                </h2>

                <p class="text-sm text-gray-600">
                    Coach: {{ $class->coach->name }}
                </p>

                <p class="text-sm">
                    {{ $class->start_time->format('d/m/Y H:i') }}
                </p>

                <p class="mt-2">
                    Cupos disponibles:
                    <strong>{{ $class->availableSpots() }}</strong>
                </p><br>
                <x-button variant="secondary" class="w-full mb-2" wire:click="openAttendeesModal({{ $class->id }})">
                  Ver clientes agendados
                </x-button>
                <x-button
                    class="mt-4 w-full"
                    wire:click="book({{ $class->id }})"
                    wire:loading.attr="disabled"
                >
                    Agendar para cliente
                </x-button>

            </div>
        @endforeach

    </div>
    <x-modal :show="$showAttendeesModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                Clientes agendados
            </h2>
            @if($selectedClass)
                <p class="text-sm text-gray-600">
                    {{ $selectedClass->discipline->name }}
                    – {{ $selectedClass->start_time->format('d/m/Y H:i') }}
                </p>
            @endif
        </x-slot>

        <div class="space-y-3">

            @forelse($attendances as $attendance)
                <div class="flex justify-between items-center border rounded-xl p-3">
                    <div>
                        <p class="font-semibold">
                            {{ $attendance->user->name }}
                        </p>
                        <p class="text-sm text-gray-500">
                            {{ $attendance->user->email }}
                        </p>
                    </div>

                    <x-button
                        variant="danger"
                        wire:click="removeAttendance({{ $attendance->id }})"
                    >
                        Eliminar
                    </x-button>
                </div>
            @empty
                <p class="text-gray-500 text-sm">
                    No hay clientes agendados para esta clase.
                </p>
            @endforelse

        </div>

        <x-slot name="footer">
            <x-button
                variant="secondary"
                wire:click="$set('showAttendeesModal', false)"
            >
                Cerrar
            </x-button>
        </x-slot>

    </x-modal>

</div>
