<div>

    <h1 class="text-2xl font-bold mb-6">
        Asistencias de Hoy
    </h1>

    @forelse($classes as $class)

        <div class="bg-white rounded-xl shadow mb-6 p-5">

            <div class="flex justify-between items-center mb-4">
                <div>
                    <h2 class="text-lg font-semibold">
                        {{ $class->discipline->name }}
                    </h2>
                    <p class="text-sm text-gray-600">
                        {{ $class->start_time->format('H:i') }}
                        –
                        {{ $class->end_time->format('H:i') }}
                        | Coach: {{ $class->coach->name }}
                    </p>
                </div>

                <span class="px-3 py-1 rounded text-sm font-semibold
                    @if($class->status === 'disponible') bg-green-100 text-green-700
                    @elseif($class->status === 'llena') bg-yellow-100 text-yellow-700
                    @elseif($class->status === 'completada') bg-gray-200 text-gray-700
                    @endif
                ">
                    {{ ucfirst($class->status) }}
                </span>
            </div>

            {{-- LISTA DE ALUMNOS --}}
            <table class="w-full">
                <thead>
                    <tr class="text-left text-sm text-gray-500">
                        <th>Alumno</th>
                        <th>Asistencia</th>
                        <th class="text-right">Acción</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($class->attendances as $attendance)
                    <tr class="border-t">
                        <td class="py-2">
                            {{ $attendance->user->name }}
                        </td>
                        <td>
                            @if($attendance->attended_at)
                                <span class="text-green-600 font-semibold">
                                    Asistió
                                </span>
                            @else
                                <span class="text-gray-500">
                                    Pendiente
                                </span>
                            @endif
                        </td>
                        <td class="text-right">
                            @if(! $attendance->attended_at)
                                <x-button
                                    variant="primary"
                                    wire:click="markAttendance({{ $attendance->id }})"
                                >
                                    Marcar
                                </x-button>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            {{-- CERRAR CLASE --}}
            @if($class->status !== 'completada')
                <div class="text-right mt-4">
                    <x-button
                        variant="secondary"
                        wire:click="closeClass({{ $class->id }})"
                    >
                        Cerrar clase
                    </x-button>
                </div>
            @endif

        </div>

    @empty
        <p class="text-gray-500">
            No hay clases programadas para hoy.
        </p>
    @endforelse

</div>
