<div>

    {{-- HEADER --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Clases</h1>
            <p class="text-gray-600">Administración de clases y horarios</p>
        </div>

        <x-button wire:click="create">
            + Nueva Clase
        </x-button>
    </div>

    {{-- SEARCH --}}
    <input
        wire:model.live="search"
        class="w-full mb-4 border rounded-xl p-2"
        placeholder="Buscar por disciplina..."
    >

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Disciplina</th>
                <th>Coach</th>
                <th>Horario</th>
                <th>Cupo</th>
                <th>Estado</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($classes as $class)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3 font-medium">
                    {{ $class->discipline->name }}
                </td>
                <td>{{ $class->coach->name }}</td>
                <td class="text-sm">
                    {{ \Carbon\Carbon::parse($class->start_time)->format('d/m/Y H:i') }}
                    –
                    {{ \Carbon\Carbon::parse($class->end_time)->format('H:i') }}
                </td>
                <td>{{ $class->max_capacity }}</td>
                <td>
                    <span class="
                        px-2 py-1 rounded text-xs font-semibold
                        @if($class->status === 'disponible') bg-green-100 text-green-700
                        @elseif($class->status === 'llena') bg-yellow-100 text-yellow-700
                        @elseif($class->status === 'cancelada') bg-red-100 text-red-700
                        @else bg-gray-200 text-gray-700
                        @endif
                    ">
                        {{ ucfirst($class->status) }}
                    </span>
                </td>
                <td class="text-right space-x-2 pr-4">
                    <x-button variant="primary" wire:click="edit({{ $class->id }})">
                        Editar
                    </x-button>

                    <x-button variant="warning" wire:click="setStatus({{ $class->id }}, 'cancelada')">
                        Cancelar
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $classes->links() }}
    </div>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Clase' : 'Nueva Clase' }}
            </h2>
        </x-slot>

        <select wire:model="discipline_id" class="w-full border rounded-xl p-2">
            <option value="">Selecciona Disciplina</option>
            @foreach($disciplines as $discipline)
                <option value="{{ $discipline->id }}">{{ $discipline->name }}</option>
            @endforeach
        </select>

        <select wire:model="coach_id" class="w-full border rounded-xl p-2">
            <option value="">Selecciona Coach</option>
            @foreach($coaches as $coach)
                <option value="{{ $coach->id }}">{{ $coach->name }}</option>
            @endforeach
        </select>

        <input type="datetime-local" wire:model="start_time" class="w-full border rounded-xl p-2">
        <input type="datetime-local" wire:model="end_time" class="w-full border rounded-xl p-2">

        <input
            type="number"
            wire:model="max_capacity"
            class="w-full border rounded-xl p-2"
            placeholder="Cupo máximo"
        >

        <select wire:model="status" class="w-full border rounded-xl p-2">
            @foreach($statuses as $status)
                <option value="{{ $status }}">{{ ucfirst($status) }}</option>
            @endforeach
        </select>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>

            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>

    </x-modal>

</div>
