<div class="flex min-h-screen bg-gray-100">

    {{-- SIDEBAR ADMIN --}}
    <aside class="w-64 bg-gray-900 text-white p-4 space-y-4">

        <h2 class="text-xl font-bold text-blue-400">
            Admin Panel
        </h2>

        <nav class="space-y-2 text-sm">

            <button wire:click="$set('section','users')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Clientes
            </button>

            <button wire:click="$set('section','agenda')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Agenda
            </button>

            <button wire:click="$set('section','attendances')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Asistencias
            </button>

            <button wire:click="$set('section','coaches')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Coaches
            </button>

            <button wire:click="$set('section','classes')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Clases
            </button>

            <button wire:click="$set('section','disciplines')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Disciplinas
            </button>

            <button wire:click="$set('section','packages')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Paquetes
            </button>

            <button wire:click="$set('section','subscriptions')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Suscripciones
            </button>

            <button wire:click="$set('section','payments')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Pagos
            </button>

            <button wire:click="$set('section','promotions')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Promociones
            </button>

            <hr class="border-gray-700">

            <button wire:click="$set('section','history-payments')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Historial Pagos
            </button>

            <button wire:click="$set('section','history-subscriptions')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Historial Suscripciones
            </button>

            <button wire:click="$set('section','history-attendanceh')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Asistencia Clases
            </button>

            <button wire:click="$set('section','history-logs')" class="w-full text-left p-2 hover:bg-gray-700 rounded">
                Logs Admin
            </button>

        </nav>
    </aside>

    {{-- CONTENT --}}
    <main class="flex-1 p-6">

        @switch($section)

            @case('users')
                <livewire:admin.users />
                @break

            @case('coaches')
                <livewire:admin.coaches />
                @break

            @case('classes')
                <livewire:admin.classes />
                @break

            @case('disciplines')
                <livewire:admin.disciplines />
                @break

            @case('packages')
                <livewire:admin.packages />
                @break

            @case('subscriptions')
                <livewire:admin.subscriptions />
                @break

            @case('payments')
                <livewire:admin.payments />
                @break

            @case('promotions')
                <livewire:admin.promotions />
                @break

            @case('history-payments')
                <livewire:admin.history.payments />
                @break

            @case('history-subscriptions')
                <livewire:admin.history.subscriptions />
                @break

            @case('history-attendanceh')
                <livewire:admin.history.attendanceh />
                @break

            @case('history-logs')
                <livewire:admin.history.logs />
                @break

            @case('attendances')
                <livewire:admin.attendances />
                @break

            @case('agenda')
                <livewire:admin.agenda />
                @break

        @endswitch

    </main>

</div>
