<div>

    <h1 class="text-2xl font-bold mb-4">
        Logs Administrativos
    </h1>

    {{-- FILTROS --}}
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-5 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los admins</option>
            @foreach($admins as $admin)
                <option value="{{ $admin->id }}">{{ $admin->name }}</option>
            @endforeach
        </select>

        <input
            wire:model.live="action"
            type="text"
            placeholder="Acción..."
            class="border rounded-lg p-2"
        >

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar
        </button>

    </div>

    {{-- TABLA --}}
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Fecha</th>
                <th>Admin</th>
                <th>Acción</th>
                <th>Descripción</th>
            </tr>
        </thead>
        <tbody>
            @forelse($logs as $log)
                <tr class="border-t">
                    <td class="p-3">
                        {{ $log->created_at->format('d/m/Y H:i') }}
                    </td>
                    <td>{{ $log->admin->name }}</td>
                    <td>{{ $log->action }}</td>
                    <td>{{ $log->description }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="p-4 text-center text-gray-400">
                        No hay logs registrados
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $logs->links() }}
    </div>

</div>
