<div>

    <h1 class="text-2xl font-bold mb-4">
        Historial de Pagos
    </h1>

    {{-- FILTROS --}}
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-5 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los clientes</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>

        <select wire:model.live="method" class="border rounded-lg p-2">
            <option value="">Método</option>
            <option value="efectivo">Efectivo</option>
            <option value="tarjeta">Tarjeta</option>
            <option value="transferencia">Transferencia</option>
        </select>

        <select wire:model.live="provider" class="border rounded-lg p-2">
            <option value="">Proveedor</option>
            <option value="manual">Manual</option>
            <option value="openpay">OpenPay</option>
        </select>

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="md:col-span-5 bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar filtros
        </button>

    </div>

    {{-- TABLA --}}
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Fecha</th>
                <th>Cliente</th>
                <th>Paquete</th>
                <th>Monto</th>
                <th>Promo</th>
                <th>Método</th>
                <th>Proveedor</th>
            </tr>
        </thead>
        <tbody>
            @forelse($payments as $payment)
                <tr class="border-t">
                    <td class="p-3">
                        {{ optional($payment->paid_at)->format('d/m/Y H:i') }}
                    </td>
                    <td>{{ $payment->user->name }}</td>
                    <td>{{ $payment->package->name }}</td>
                    <td>${{ number_format($payment->amount, 2) }}</td>
                    <td>
                        @if($payment->promotion_percent)
                            {{ $payment->promotion_percent }}%
                        @else
                            —
                        @endif
                    </td>
                    <td class="capitalize">{{ $payment->payment_method }}</td>
                    <td class="capitalize">{{ $payment->provider }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="p-4 text-center text-gray-400">
                        No hay pagos registrados
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $payments->links() }}
    </div>

</div>
