<div>

    <h1 class="text-2xl font-bold mb-4">
        Historial de Suscripciones
    </h1>

    {{-- FILTROS --}}
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-6 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los clientes</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>

        <select wire:model.live="package_id" class="border rounded-lg p-2">
            <option value="">Todos los paquetes</option>
            @foreach($packages as $package)
                <option value="{{ $package->id }}">{{ $package->name }}</option>
            @endforeach
        </select>

        <select wire:model.live="status" class="border rounded-lg p-2">
            <option value="">Estado</option>
            @foreach($statuses as $state)
                <option value="{{ $state }}">{{ ucfirst($state) }}</option>
            @endforeach
        </select>

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar
        </button>

    </div>

    {{-- TABLA --}}
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Cliente</th>
                <th>Paquete</th>
                <th>Inicio</th>
                <th>Fin</th>
                <th>Clases</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            @forelse($subscriptions as $subscription)
                <tr class="border-t">
                    <td class="p-3">{{ $subscription->user->name }}</td>
                    <td>{{ $subscription->package->name }}</td>
                    <td>{{ optional($subscription->start_date)->format('d/m/Y') }}</td>
                    <td>{{ optional($subscription->end_date)->format('d/m/Y') }}</td>
                    <td>
                        {{ $subscription->remaining_classes ?? 'Ilimitadas' }}
                    </td>
                    <td>
                        <span class="px-2 py-1 rounded-full text-xs
                            @if($subscription->status === 'activa') bg-green-100 text-green-700
                            @elseif($subscription->status === 'pausada') bg-yellow-100 text-yellow-700
                            @elseif($subscription->status === 'vencida') bg-gray-200 text-gray-700
                            @elseif($subscription->status === 'cancelada') bg-red-100 text-red-700
                            @else bg-blue-100 text-blue-700
                            @endif
                        ">
                            {{ ucfirst($subscription->status) }}
                        </span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="p-4 text-center text-gray-400">
                        No hay suscripciones registradas
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $subscriptions->links() }}
    </div>

</div>
