<div>

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Paquetes</h1>

        <x-button wire:click="create">
            + Nuevo Paquete
        </x-button>
    </div>

    <input wire:model.live="search"
           class="w-full mb-4 border rounded-xl p-2"
           placeholder="Buscar paquete...">

    <table class="w-full bg-white rounded-xl shadow">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Nombre</th>
                <th>Precio</th>
                <th>Clases</th>
                <th>Duración</th>
                <th>Tipo</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($packages as $package)
            <tr class="border-t">
                <td class="p-3">{{ $package->name }}</td>
                <td>${{ $package->price }}</td>
                <td>{{ $package->classes_limit ?? 'Ilimitadas' }}</td>
                <td>{{ $package->duration_days }} días</td>
                <td>{{ $package->is_subscription ? 'Suscripción' : 'Único' }}</td>
                <td class="text-right pr-4 space-x-2">
                    <x-button variant="icon" wire:click="edit({{ $package->id }})">✏️</x-button>
                    <x-button variant="warning" wire:click="toggleStatus({{ $package->id }})">
                        {{ $package->is_active ? 'Desactivar' : 'Activar' }}
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $packages->links() }}

    {{-- MODAL --}}
    <x-modal :show="$showModal">
        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Paquete' : 'Nuevo Paquete' }}
            </h2>
        </x-slot>

        <input wire:model="name" class="w-full border rounded-xl p-2" placeholder="Nombre">
        <textarea wire:model="description" class="w-full border rounded-xl p-2" placeholder="Descripción"></textarea>
        <input wire:model="price" type="number" class="w-full border rounded-xl p-2" placeholder="Precio">
        <input wire:model="classes_limit" type="number" class="w-full border rounded-xl p-2" placeholder="Clases (vacío = ilimitado)">
        <input wire:model="duration_days" type="number" class="w-full border rounded-xl p-2" placeholder="Duración (días)">

        <label class="flex items-center gap-2">
            <input type="checkbox" wire:model="is_subscription">
            Es suscripción
        </label>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">Cancelar</x-button>
            <x-button wire:click="save">Guardar</x-button>
        </x-slot>
    </x-modal>

</div>
