<div>

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Promociones</h1>

        <x-button wire:click="create">
            + Nueva Promoción
        </x-button>
    </div>

    <table class="w-full bg-white rounded-xl shadow">
        <thead>
            <tr class="text-left text-sm text-gray-500">
                <th class="p-3">Nombre</th>
                <th>Descuento</th>
                <th>Vigencia</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($promotions as $promo)
            <tr class="border-t">
                <td class="p-3">{{ $promo->name }}</td>
                <td>{{ $promo->discount_percent }}%</td>
                <td>
                    {{ $promo->valid_from ?? '—' }}
                    –
                    {{ $promo->valid_to ?? '—' }}
                </td>
                <td>
                    <span class="px-2 py-1 rounded text-xs
                        {{ $promo->active ? 'bg-green-100 text-green-700' : 'bg-gray-200' }}">
                        {{ $promo->active ? 'Activa' : 'Inactiva' }}
                    </span>
                </td>
                <td class="flex gap-4">
                  <x-button variant="primary" wire:click="edit({{ $promo->id }})">
                      Editar
                  </x-button>
                  <x-button variant="warning" wire:click="toggle({{ $promo->id }})">
                      {{ $promo->active ? 'Desactivar' : 'Activar' }}
                  </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $promotions->links() }}

    <x-modal :show="$showModal">
        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar' : 'Nueva' }} Promoción
            </h2>
        </x-slot>

        <input wire:model="name" placeholder="Nombre" class="w-full border rounded-xl p-2">

        <input
            wire:model="discount_percent"
            type="number"
            placeholder="% de descuento"
            class="w-full border rounded-xl p-2"
        >

        <div class="flex gap-2">
            <input wire:model="valid_from" type="date" class="w-full border rounded-xl p-2">
            <input wire:model="valid_to" type="date" class="w-full border rounded-xl p-2">
        </div>

        <label class="flex items-center gap-2">
            <input type="checkbox" wire:model="active">
            Activa
        </label>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>
            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>
    </x-modal>

</div>
