<div>

    {{-- HEADER --}}
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Clientes</h1>
            <p class="text-gray-600">Administración de usuarios clientes</p>
        </div>

        <x-button wire:click="create">
            + Nuevo Cliente
        </x-button>
    </div>

    {{-- SEARCH --}}
    <input
        wire:model.live="search"
        class="w-full mb-4 border rounded-xl p-2"
        placeholder="Buscar cliente..."
    >

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Nombre</th>
                <th>Email</th>
                <th>Estado</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($users as $user)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3">{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>
                    @if($user->is_active)
                        <span class="text-green-600 font-semibold">Activo</span>
                    @else
                        <span class="text-red-600 font-semibold">Suspendido</span>
                    @endif
                </td>
                <td class="text-right space-x-2 pr-4">
                    <x-button variant="secondary" wire:click="edit({{ $user->id }})">
                        Editar
                    </x-button>

                    <x-button
                        variant="{{ $user->is_active ? 'warning' : 'primary' }}"
                        wire:click="toggleStatus({{ $user->id }})"
                    >
                        {{ $user->is_active ? 'Suspender' : 'Activar' }}
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $users->links() }}
    </div>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                {{ $editMode ? 'Editar Cliente' : 'Nuevo Cliente' }}
            </h2>
        </x-slot>

        <input
            wire:model="name"
            class="w-full border rounded-xl p-2"
            placeholder="Nombre"
        >

        <input
            wire:model="email"
            class="w-full border rounded-xl p-2"
            placeholder="Email"
        >

        <input
            type="password"
            wire:model="password"
            class="w-full border rounded-xl p-2"
            placeholder="{{ $editMode ? 'Nueva contraseña (opcional)' : 'Contraseña' }}"
        >

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>

            <x-button wire:click="save">
                Guardar
            </x-button>
        </x-slot>

    </x-modal>

</div>
