<div>

    <div class="mb-6">
        <h1 class="text-2xl font-bold">Webhooks OpenPay</h1>
        <p class="text-gray-600">
            Eventos recibidos desde OpenPay
        </p>
    </div>

    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Fecha</th>
                <th>Evento</th>
                <th>Transacción</th>
                <th>Estado</th>
                <th class="text-right pr-4">Payload</th>
            </tr>
        </thead>
        <tbody>
            @foreach($webhooks as $webhook)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3">{{ $webhook->created_at }}</td>
                <td>{{ $webhook->event_type }}</td>
                <td>{{ $webhook->transaction_id }}</td>
                <td>
                    @if($webhook->status === 'processed')
                        <span class="text-green-600 font-semibold">Procesado</span>
                    @elseif($webhook->status === 'failed')
                        <span class="text-red-600 font-semibold">Fallido</span>
                    @else
                        <span class="text-yellow-600 font-semibold">Recibido</span>
                    @endif
                </td>
                <td class="text-right pr-4">
                    <details>
                        <summary class="cursor-pointer text-purple-600">
                            Ver
                        </summary>
                        <pre class="bg-gray-100 p-3 rounded mt-2 text-xs overflow-x-auto">
{{ json_encode($webhook->payload, JSON_PRETTY_PRINT) }}
                        </pre>
                    </details>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="mt-4">
        {{ $webhooks->links() }}
    </div>

</div>
