<div>

    {{-- HEADER --}}
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Administración de Permisos</h1>
        <p class="text-gray-600">
            Asigna permisos directamente a los usuarios
        </p>
    </div>

    {{-- TABLE --}}
    <table class="w-full bg-white rounded-xl shadow overflow-hidden">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3 text-left">Usuario</th>
                <th>Email</th>
                <th>Rol</th>
                <th class="text-right pr-4">Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($users as $user)
            <tr class="border-t hover:bg-gray-50">
                <td class="p-3">{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>{{ $user->roles->pluck('name')->implode(', ') }}</td>
                <td class="text-right pr-4">
                    <x-button wire:click="editPermissions({{ $user->id }})">
                        Gestionar Permisos
                    </x-button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{-- MODAL --}}
    <x-modal :show="$showModal">

        <x-slot name="header">
            <h2 class="text-xl font-bold">
                Permisos de {{ $selectedUser?->name }}
            </h2>
        </x-slot>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 max-h-64 overflow-y-auto">

            @foreach($permissions as $permission)
                <label class="flex items-center gap-2">
                    <input
                        type="checkbox"
                        wire:model="userPermissions"
                        value="{{ $permission->name }}"
                        class="rounded"
                    >
                    <span>{{ $permission->name }}</span>
                </label>
            @endforeach

        </div>

        <x-slot name="footer">
            <x-button variant="secondary" wire:click="$set('showModal', false)">
                Cancelar
            </x-button>

            <x-button wire:click="savePermissions">
                Guardar Permisos
            </x-button>
        </x-slot>

    </x-modal>

</div>
