<div>
    <h1 class="text-2xl font-bold mb-4">Agenda</h1>

    @if(!$subscription)
        <div class="bg-yellow-100 text-yellow-800 p-3 rounded">
            No tienes una suscripción activa.
        </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
        @foreach($classes as $class)
            <div class="bg-white p-4 rounded-xl shadow">
                <h3 class="font-semibold">{{ $class->discipline->name }}</h3>
                <p>{{ $class->start_time->format('d/m/Y H:i') }}</p>
                <p>Coach: {{ $class->coach->name }}</p>

                <button
                    wire:click="enroll({{ $class->id }})"
                    @disabled(!$subscription)
                    class="mt-3 w-full bg-purple-600 text-white p-2 rounded disabled:opacity-50"
                >
                    Agendar
                </button>
            </div>
        @endforeach
    </div>
</div>
