<div>
    <h1 class="text-2xl font-bold mb-4">Agenda</h1>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        @foreach($classes as $class)
            <div class="bg-white p-4 rounded-xl shadow">
                <h3 class="font-semibold">{{ $class->discipline->name }}</h3>

                <p>{{ $class->start_time->format('d/m/Y H:i') }}</p>
                <p>Coach: {{ $class->coach->name }}</p>

                <p class="mt-2 text-sm">
                    Cupos: {{ $class->spots_left }}
                </p>

                {{-- 🔥 LÓGICA SIMPLE --}}
                @if($class->is_enrolled)
                    <button
                        wire:click="cancel({{ $class->id }})"
                        class="mt-3 w-full bg-red-500 text-white p-2 rounded-xl">
                        Cancelar
                    </button>

                @elseif($class->spots_left === 0)
                    <button
                        disabled
                        class="mt-3 w-full bg-gray-400 text-white p-2 rounded-xl">
                        Clase llena
                    </button>

                @else
                    <button
                        wire:click="enroll({{ $class->id }})"
                        class="mt-3 w-full bg-purple-600 text-white p-2 rounded-xl">
                        Agendar
                    </button>
                @endif
            </div>
        @endforeach
    </div>
</div>
