<div>
    <h1 class="text-2xl font-bold mb-4">Mis Pagos</h1>

    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Fecha</th>
                <th>Paquete</th>
                <th>Monto</th>
                <th>Promo</th>
            </tr>
        </thead>
        <tbody>
            @forelse($payments as $payment)
                <tr class="border-t">
                    <td class="p-3">{{ $payment->paid_at->format('d/m/Y') }}</td>
                    <td>{{ $payment->package->name }}</td>
                    <td>${{ number_format($payment->amount,2) }}</td>
                    <td>{{ $payment->promotion_percent ? $payment->promotion_percent.'%' : '—' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="p-4 text-center text-gray-400">
                        No tienes pagos registrados
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
