<div>

    <h1 class="text-2xl font-bold mb-4">
        Historial de Suscripciones
    </h1>

    
    <div class="bg-white p-4 rounded-xl shadow mb-6 grid grid-cols-1 md:grid-cols-6 gap-3">

        <select wire:model.live="user_id" class="border rounded-lg p-2">
            <option value="">Todos los clientes</option>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </select>

        <select wire:model.live="package_id" class="border rounded-lg p-2">
            <option value="">Todos los paquetes</option>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </select>

        <select wire:model.live="status" class="border rounded-lg p-2">
            <option value="">Estado</option>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($state); ?>"><?php echo e(ucfirst($state)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </select>

        <input wire:model.live="from" type="date" class="border rounded-lg p-2">
        <input wire:model.live="to" type="date" class="border rounded-lg p-2">

        <button
            wire:click="resetFilters"
            class="bg-gray-200 hover:bg-gray-300 rounded-lg p-2"
        >
            Limpiar
        </button>

    </div>

    
    <table class="w-full bg-white rounded-xl shadow text-sm">
        <thead>
            <tr class="text-left text-gray-500">
                <th class="p-3">Cliente</th>
                <th>Paquete</th>
                <th>Inicio</th>
                <th>Fin</th>
                <th>Clases</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t">
                    <td class="p-3"><?php echo e($subscription->user->name); ?></td>
                    <td><?php echo e($subscription->package->name); ?></td>
                    <td><?php echo e(optional($subscription->start_date)->format('d/m/Y')); ?></td>
                    <td><?php echo e(optional($subscription->end_date)->format('d/m/Y')); ?></td>
                    <td>
                        <?php echo e($subscription->remaining_classes ?? 'Ilimitadas'); ?>

                    </td>
                    <td>
                        <span class="px-2 py-1 rounded-full text-xs
                            <?php if($subscription->status === 'activa'): ?> bg-green-100 text-green-700
                            <?php elseif($subscription->status === 'pausada'): ?> bg-yellow-100 text-yellow-700
                            <?php elseif($subscription->status === 'vencida'): ?> bg-gray-200 text-gray-700
                            <?php elseif($subscription->status === 'cancelada'): ?> bg-red-100 text-red-700
                            <?php else: ?> bg-blue-100 text-blue-700
                            <?php endif; ?>
                        ">
                            <?php echo e(ucfirst($subscription->status)); ?>

                        </span>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="p-4 text-center text-gray-400">
                        No hay suscripciones registradas
                    </td>
                </tr>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="mt-4">
        <?php echo e($subscriptions->links()); ?>

    </div>

</div>
<?php /**PATH C:\laragon\www\pilates-app\resources\views/livewire/admin/history/subscriptions.blade.php ENDPATH**/ ?>